from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''

    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token

FUND_CLASS_KEY = ''
ASSIGNMENT_CONFIGURATION_KEY = ''
BASE_URL = f'fund_class/{FUND_CLASS_KEY}/assignment_configuration/{ASSIGNMENT_CONFIGURATION_KEY}'
EXTERNAL_ID = ''

base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = f"/trade_receivables/{BASE_URL}/assignment/{EXTERNAL_ID}/asset"
method = "POST"

body = {
    "asset_type": "ccb",
    "total_purchase_value": 1351.66,
    "premiums": [
      {
        "premium_type": "spread",
        "total_value": 13.38
      }
    ],
    "credit_operation": {
      "contract": {
        "number": "0008309052/NBF",
        "disbursement_date": "2023-07-06",
        "issue_date": "2023-07-06",
        "signature_date": "2023-07-06",
        "issue_value": 1338.28
      },
      "amortization_type": "sac",
      "borrower": {
        "name": "QI DTVM",
        "document_number": "19.845.976/0001-93",
        "person_type": "legal_person",
        "email": "qidtvm@qitech.com.br",
        "address": {
          "street": "Pátio de Teixeira",
          "number": "1",
          "neighborhood": "Estrela do Oriente",
          "city": "Rondônia",
          "postal_code": "01012-030",
          "uf": "RO",
          "country": "BRA"
        },
        "phone": {
          "area_code": "11",
          "number": "936360268"
        },
        "legal_person": {
          "activity_code": "11.11-1-11"
        }
      },
      "delay": {
        "fine": {
          "fine_type": "percentage",
          "percentage_value": 0.0
        },
        "interest": {
          "method": "compound",
          "pre_fixed": {
            "monthly_rate": 0.0,
            "calendar_base": "calendar_360"
          }
        }
      },
      "principal_value": 1338.28,
      "interest_rate_type": "pre_fixed",
      "external_id": "ccf6f331-d55f-46c0-a32f-fb909884dbb2",
      "originator_document_number": "53.020.654/0001-43",
      "pre_fixed": {
        "calendar_base": "calendar_365",
        "monthly_rate": 0.018
      },
      "installments": [
        {
          "maturity_date": "2023-10-01",
          "installment_number": 1,
          "face_value": 267.65
        },
        {
          "maturity_date": "2024-10-01",
          "installment_number": 2,
          "face_value": 267.65
        },
        {
          "maturity_date": "2025-10-01",
          "installment_number": 3,
          "face_value": 267.65
        },
        {
          "maturity_date": "2026-10-01",
          "installment_number": 4,
          "face_value": 267.65
        },
        {
          "maturity_date": "2027-10-01",
          "installment_number": 5,
          "face_value": 267.65
        },
        {
          "maturity_date": "2028-10-01",
          "installment_number": 6,
          "face_value": 267.65
        }
      ],
      "modality_code": "0203",
    }
}



encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.post(url=url, headers=headers, json=body)
print(resp.json())
